# SmallMart v6 — Documentation

This build upgrades **SmallMart** to v6.0 with:
- **Auto-resizing logo upload** (Admin → Settings)
- **Package-based Mods** + legacy `mods/*.php`
- **Folder Themes** (`themes/<id>/theme.json`) + Theme Builder
- **User accounts** (register/login, change username/email/password, email verify + reset)
- **Backlink-removal license** (Admin → License) with **PayPal IPN verification**

## Quick Install
1. Upload `index.php` plus folders: `data/`, `uploads/`, `mods/`, `themes/`, `docs/`
2. Ensure PHP can write to:
   - `data/`
   - `uploads/`
3. Visit the site.

### Default Admins
- **Admin panel**: right-click the site title/logo (or use the Admin button) and login with:
  - password: `demopass`
- **User account (store login)** (created automatically if no admin users exist):
  - username: `admin`
  - password: `demopass`

## Backlink Removal License ($5)
- Go to **Admin → License**
- Pay $5 via the provided PayPal button
- PayPal IPN will mark the license **PAID**
- Then you can toggle the footer backlink in **Admin → Settings**.

> IPN endpoint is shown on the License page as `?paypal_ipn=1`.

## Mods
See `docs/MODS.md`.

## Themes
See `docs/THEMES.md`.

## User Accounts
- Login: `?account=login`
- Register: `?account=register`
- Settings: `?account=settings`

Email verification + reset require configuring sender email in Admin → Settings.
Enable **Dev: Show email links** to see verification/reset links on-screen while testing.

